/************************************************************************
GAUSS code: 
File: Lagsel.prg (Note: not used with Exercise 5.4)
  
Modification of computer code written by Jean-Yves Pitarakis.

In this program we evaluate the properties of lag lengths
estimated in the context of AR(p) models when the true DGP
is a threshold model. We use a SETAR type DGP and fit AR(p)
(p=1,2,....,pmax) models to the data. 

We select the appropriate lag lengths via the AIC, BIC and HQ criteria. 
Note: A constant is always included in the fitted models.

Reference:
Pitarakis, J.-Y. (2006). Model selection uncertainty and detection of 
  threshold effects.
  Studies in Nonlinear Dynamics & Econometrics, 10(1), 1-30.
  DOI: 10.2202/1558-3708.1256.
************************************************************************ */
new;
format /m1 /ldn 3,4;
t = 200+50; @ Sample Size @
y = zeros(t,1);
n = 2000;   @ Replications @

paic = zeros(n,1);
pbic = zeros(n,1);
phic = zeros(n,1);
pmax = 6;   @ Maximum Lag Order @

/* Model Exercise 5.4 DGP (i) */
  f01 = 0.5; f11 = 0.2;f21 = -0.1; f02 = 0.3; f12 = -0.2; f22 = 0.1;
  
/*
/* Model Exercise 5.4 DGP (ii) */
  f01 = 0.5; f11 = -0.1; f21 = 0.1; f02 = 0.3; f12 = 0.1; f22 = -0.1;
*/

j=1;  @ Looping over Replications @
do while j<=n;
   e = rndn(t,1);
   i = 3;
   do while i<=t; @ DGP Below @
      y[i] = (f01+f11*y[i-1]+f21*y[i-2])*(y[i-2]<=0)+
             (f02+f12*y[i-1]+f22*y[i-2])*(y[i-2]>0)+e[i];
      i    = i+1;
   endo;

   z      = y[51:t]; @ We omit the first 50 observations @
   lagvec = lagsel(z,pmax); @ Calling the lag length estimation procedure @

   paic[j] = lagvec[1,1];
   pbic[j] = lagvec[2,1];
   phic[j] = lagvec[3,1];
/*   j~paic[j]~pbic[j]~phic[j]; */
   j = j+1;
endo;

"Lag Lengths Selected: over 2000 MC replications";
"True p0 of SETAR(2;2,2) = 2";
"Empirical frequencies of selecting a specific lag order"; 
"AIC--------BIC-----------HQ------";

veco1 = seqa(1,1,pmax)~counts(paic,seqa(1,1,pmax))/n;
veco2 = counts(pbic,seqa(1,1,pmax))/n~counts(phic,seqa(1,1,pmax))/n;
veco1~veco2;

/*
LAGSEL

This procedure fits AR(p) models to the data and selects the optimal
lag length using the AIC, BIC and HQ criteria. It takes the data and
the maximum lag length as inputs.

Note: p is assumed to lie in the [1,pmax] interval
*/

proc(1) = lagsel(dat,maxlag);
local laic,lbic,lhic,k,y,h,yr,z,beta,res,rres,plinaic,plinbic,plinhic,n,sig;

laic = zeros(maxlag,1);
lbic = zeros(maxlag,1);
lhic = zeros(maxlag,1);
sig  = zeros(maxlag,1);

n = rows(dat);

k = 1;
do while k<=maxlag;
   y = dat[k+1:n];
   h = 1;
   do while h<=k;
     y = y~dat[k+1-h:n-h];
     h = h+1;
   endo;

   yr   = y[.,1];
   z    = ones(rows(yr),1)~y[.,2:cols(y)];
   beta = yr/z;
   res  = yr-z*beta;
   rres = rows(res);

   laic[k] = ln(res'res/rres)+(2/rres)*(k+1);
   lbic[k] = ln(res'res/rres)+(ln(rres)/rres)*(k+1);
   lhic[k] = ln(res'res/rres)+(2*ln(ln(rres))/rres)*(k+1);
   k       = k+1;
endo;

plinaic = minindc(laic)~minc(laic);
plinbic = minindc(lbic)~minc(lbic);
plinhic = minindc(lhic)~minc(lhic);

retp(plinaic|plinbic|plinhic);
endp;







